package gov.va.vinci.dart.db.impl;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Facility;
import gov.va.vinci.dart.db.FacilityDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class FacilityDAOImpl extends HibernateDAO implements FacilityDAO {

	@Override
	public Facility findById(final int locationId) {
		Query q = createQuery("from Facility where id=:lid");
		q.setParameter("lid", locationId);
		return (Facility)q.getSingleResult();
	}

	@Override
	public Facility findByName(final String name) throws ObjectNotFoundException {
		
		Query query = createQuery("from Facility where name like :fname");
		query.setParameter("fname", name);
		try {
			return (Facility)query.getSingleResult();
		} catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<Facility> listAll() {
		Query query = createQuery("from Facility");
		return (List<Facility>)query.getResultList();
	}

}
